/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.link.L2tpLink;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;

public class L2tpVpnLink
extends L2tpLink {
    private static final String TRACE_MASKT = "XRCSLVLT";
    private static final String TRACE_MASKF = "XRCSLVLF";
    private static final String TRACE_MASKD = "XRCSLVLD";
    private static L2tpVpnLink instance;

    protected L2tpVpnLink() {
        this.maxOpenPaths = 5;
        this.highPerformance = true;
        Trace.trace(TRACE_MASKT, "<-> L2tpVpnLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new L2tpVpnLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            throw new LinkAlreadyActiveException();
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = 0;
            OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
            Iterator i = outConfig.getPassthruInfo().iterator();
            while (i.hasNext()) {
                PassthruInfo pInfo = (PassthruInfo)i.next();
                String ip = pInfo.getIpAddress();
                RcsConfig.getRcsConfig().setTemporaryConfigValue("l2tp_remote_host", ip);
                rc = RcsControl.startRemVpn();
                if (rc != 0) continue;
                this.active = true;
                break;
            }
            if (!this.active) {
                throw new LinkFailedException("Failed to remote vpn (RC: " + rc + ")");
            }
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopRemVpn();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowPassthru() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }
}

